


IF EXISTS(SELECT * FROM SYS.procedures WHERE NAME = 'P_PDV_VD_IT_REC_PELO_SNGPC' )
    BEGIN 
		DROP PROCEDURE P_PDV_VD_IT_REC_PELO_SNGPC;
    END;
GO


/*

=======================================================================================
'Job.................: Linx - Vincular receita a venda pelo SNGPC  / Linx - Manutencao 15 min.
'Função..............: 
'Objetivo............: Vinculo da venda com receita  
'Tabelas.............: PDV_VD_IT_REC
'Dt Modificação......: 20/11/2020
'Modificação.........: Tag #A002 - Adicionar o CD_IT no tratamento de duplicidade de CRM 
'=======================================================================================
Tag #A001 - Alteração do codigo  
Tag #I001 - Inclusão de novo codigo 

*/

CREATE PROCEDURE P_PDV_VD_IT_REC_PELO_SNGPC
                 @QTDEDIAS INT = 15
AS
     BEGIN
         SET NOCOUNT ON;
         DECLARE @DT_INI DATETIME;
         DECLARE @DT_FIM DATETIME;
         SET @DT_FIM = CONVERT(CHAR(10), GETDATE(), 112);
         SET @DT_INI = @DT_FIM - @QTDEDIAS;
         DECLARE @CD_EMP INT;
         DECLARE @CD_FILIAL INT;
         DECLARE @CD_PROD INT;
         DECLARE @CD_IT INT;
         DECLARE @NR_ORC INT;
         DECLARE @NR_ORC_ANT INT;

         CREATE TABLE #RS_RET(
            CD_EMP INT ,
            CD_FILIAL INT ,
            CD_VD INT ,
            CD_IT INT ,
            CD_MEDICO_REC INT ,
            NR_RECEITA VARCHAR(100) ,
            DT_RECEITA DATETIME ,
            COMPRADOR_NOME VARCHAR(100) ,
            COMPRADOR_DOC_NUMERO VARCHAR(100) ,
            COMPRADOR_DOC_TIPO INT ,
            COMPRADOR_DOC_EXPEDIDOR VARCHAR(100) ,
            COMPRADOR_DOC_UF VARCHAR(100) ,
            PACIENTE_NOME VARCHAR(100) ,
            PACIENTE_IDADE INT ,
            PACIENTE_TP_IDADE INT ,
            PACIENTE_SEXO INT ,
            PACIENTE_CID VARCHAR(100) ,
            MEDICAMENTO_NUMERO_LOTE VARCHAR(100) ,
            MEDICAMENTO_RECEITA_TIPO INT ,
            MEDICAMENTO_NUMERO_NOTIFICACAO VARCHAR(100) ,
            MEDICAMENTO_DATA_PRESCRICAO DATETIME ,
            MEDICANENTO_DATA_VENDA DATETIME ,
            STS_IMPORT INT ,
            ORIGEM_REC INT ,
            CODIGO_CONTROLE_ORIGEM INT
        );
         
		 
		 PRINT 'Inicio da rotina - Hora : '+CONVERT(VARCHAR, GETDATE(), 108);
         PRINT 'Analisando duplicidade de CRM - Hora : '+CONVERT(VARCHAR, GETDATE(), 108);
         
-- Tag #A002
		 DECLARE RECEITASDUP CURSOR FAST_FORWARD
         FOR SELECT  
                    CD_EMP
                  , CD_FILIAL
                  , NR_ORC
                  , CD_PROD
                  , CD_IT
             FROM
                  EST_ORC_GLB_MEDICO
             WHERE CD_EMP = 1 
			   AND NR_ORC IN ( SELECT NR_ORC 
								 FROM EST_ORC_GLB_MEDICO
								WHERE CD_EMP = 1 
			   
								GROUP BY 
										  CD_EMP
										, CD_FILIAL
										, NR_ORC
                                        , CD_PROD
                                             
										HAVING COUNT(NR_ORC) > 1
									)
             ORDER BY
                      CD_EMP
                    , CD_FILIAL
                    , NR_ORC
                    , CD_PROD
					, CD_IT;

         SET @NR_ORC_ANT = 0;
         OPEN RECEITASDUP;
         FETCH NEXT FROM RECEITASDUP INTO @CD_EMP
                                        , @CD_FILIAL
                                        , @NR_ORC
                                        , @CD_PROD
										, @CD_IT
                                        ;
         WHILE @@FETCH_STATUS = 0
             BEGIN
                 IF @NR_ORC_ANT <> @NR_ORC
                     BEGIN
                         DELETE FROM EST_ORC_GLB_MEDICO
                         WHERE
                               CD_EMP = @CD_EMP
                               AND CD_FILIAL = @CD_FILIAL
                               AND CD_PROD   = @CD_PROD
                               AND NR_ORC    = @NR_ORC
                               AND CD_IT     = @CD_IT;
                         SET @NR_ORC_ANT = @NR_ORC;
                     END;
					 --PROXIMO REGISTRO    
                 FETCH NEXT FROM RECEITASDUP INTO @CD_EMP
                                                , @CD_FILIAL
                                                , @NR_ORC
                                                , @CD_PROD
												, @CD_IT
                                                ;
             END;    
         CLOSE RECEITASDUP;    
         DEALLOCATE RECEITASDUP;

/**********************************************************************************************************************************************/
		DECLARE @CdLoja Int;
		DECLARE cFiliais CURSOR FAST_FORWARD READ_ONLY
        FOR SELECT CD_FILIAL
             FROM
                  PRC_FILIAL
             WHERE 
				CD_EMP=1
			ORDER BY CD_FILIAL; 
		OPEN cFiliais;
        FETCH NEXT FROM cFiliais INTO @CdLoja
        WHILE @@FETCH_STATUS = 0
			BEGIN
			 
			 PRINT '***************'
			 PRINT ' Filial ' + convert(varchar,@CdLoja)
			 PRINT '***************'



			 INSERT INTO #RS_RET
				(
					CD_EMP
				  , CD_FILIAL
				  , CD_VD
				  , CD_IT
				  , CD_MEDICO_REC
				  , NR_RECEITA
				  , DT_RECEITA
				  , COMPRADOR_NOME
				  , COMPRADOR_DOC_NUMERO
				  , COMPRADOR_DOC_TIPO
				  , COMPRADOR_DOC_EXPEDIDOR
				  , COMPRADOR_DOC_UF
				  , PACIENTE_NOME
				  , PACIENTE_IDADE
				  , PACIENTE_TP_IDADE
				  , PACIENTE_SEXO
				  , PACIENTE_CID
				  , MEDICAMENTO_NUMERO_LOTE
				  , MEDICAMENTO_RECEITA_TIPO
				  , MEDICAMENTO_NUMERO_NOTIFICACAO
				  , MEDICAMENTO_DATA_PRESCRICAO
				  , MEDICANENTO_DATA_VENDA
				  , STS_IMPORT
				  , ORIGEM_REC
                  , CODIGO_CONTROLE_ORIGEM
				)
				SELECT DISTINCT
						IT.CD_EMP
						, IT.CD_FILIAL
						, IT.CD_VD
						, IT.CD_IT
						, MED.CD_CTR AS CD_MEDICO_REC
						, '' AS NR_RECEITA
						, VD.DT_VD AS DT_RECEITA
						, ISNULL(CRM.NM_COMPRADOR, '') AS COMPRADOR_NOME
						, '' AS COMPRADOR_DOC_NUMERO
						, 0 AS COMPRADOR_DOC_TIPO
						, '' AS COMPRADOR_DOC_EXPEDIDOR
						, '' AS COMPRADOR_DOC_UF
						, '' AS PACIENTE_NOME
						, 0 AS PACIENTE_IDADE
						, 0 AS PACIENTE_TP_IDADE
						, 0 AS PACIENTE_SEXO
						, '' AS PACIENTE_CID
						, '' AS MEDICAMENTO_NUMERO_LOTE
						, 0 AS MEDICAMENTO_RECEITA_TIPO
						, '' AS MEDICAMENTO_NUMERO_NOTIFICACAO
						, NULL AS MEDICAMENTO_DATA_PRESCRICAO
						, VD.DT_VD AS MEDICANENTO_DATA_VENDA
						, 0 AS STS_IMPORT
						, 1 AS ORIGEM_REC
                        , CRM.NR_ORC
				FROM
						PDV_VD VD
						INNER JOIN PDV_VD_IT IT ON VD.CD_EMP = IT.CD_EMP
												AND VD.CD_FILIAL = IT.CD_FILIAL
												AND VD.CD_VD = IT.CD_VD
												AND VD.DT_VD = IT.DT_VD
						inner join PDV_VD_EST_ORC VINC_ORC ON    
						     VINC_ORC.CD_EMP = VD.CD_EMP
							 AND VINC_ORC.CD_FILIAL = VD.CD_FILIAL
							 AND VINC_ORC.CD_vD = VD.CD_VD
						INNER JOIN EST_ORC ORC ON VINC_ORC.CD_EMP = ORC.CD_EMP
												AND VINC_ORC.CD_FILIAL = ORC.CD_FILIAL
												AND VINC_ORC.CD_ORC = ORC.CD_ORC
						INNER JOIN EST_ORC_GLB_MEDICO CRM ON ORC.CD_EMP = CRM.CD_EMP
															AND ORC.CD_FILIAL = CRM.CD_FILIAL
															AND ORC.CD_ORC = CRM.NR_ORC
						INNER JOIN GLB_MEDICOS MED ON CRM.CD_EMP = MED.CD_EMP
													AND CRM.CD_MEDICO_REC = MED.CD_CTR
						LEFT OUTER JOIN PDV_VD_IT_REC ON IT.CD_EMP = PDV_VD_IT_REC.CD_EMP
														AND IT.CD_FILIAL = PDV_VD_IT_REC.CD_FILIAL
														AND IT.CD_VD = PDV_VD_IT_REC.CD_VD
														AND IT.CD_IT = PDV_VD_IT_REC.CD_IT
				WHERE IT.CD_EMP = 1
						AND IT.CD_FILIAL = CRM.CD_FILIAL
						AND IT.CD_PROD = CRM.CD_PROD
						AND IT.ST_IT = 1
						AND VD.ST_VD = 0
						AND IT.DT_VD BETWEEN @DT_INI AND @DT_FIM
						AND IT.CD_FILIAL = @CdLoja
                        AND ISNULL(CRM.SUBSIDIO, 0) = 0
						AND PDV_VD_IT_REC.CD_IT IS NULL;


			    PRINT 'Inserindo CRM pelo orcamento na pdv receita- Hora : '+CONVERT(VARCHAR, GETDATE(), 108);
                INSERT INTO PDV_VD_IT_REC 
                (
					CD_EMP
				  , CD_FILIAL
				  , CD_VD
				  , CD_IT
				  , CD_MEDICO_REC
				  , NR_RECEITA
				  , DT_RECEITA
				  , COMPRADOR_NOME
				  , COMPRADOR_DOC_NUMERO
				  , COMPRADOR_DOC_TIPO
				  , COMPRADOR_DOC_EXPEDIDOR
				  , COMPRADOR_DOC_UF
				  , PACIENTE_NOME
				  , PACIENTE_IDADE
				  , PACIENTE_TP_IDADE
				  , PACIENTE_SEXO
				  , PACIENTE_CID
				  , MEDICAMENTO_NUMERO_LOTE
				  , MEDICAMENTO_RECEITA_TIPO
				  , MEDICAMENTO_NUMERO_NOTIFICACAO
				  , MEDICAMENTO_DATA_PRESCRICAO
				  , MEDICANENTO_DATA_VENDA
				  , STS_IMPORT
				  , ORIGEM_REC
				)
                SELECT CD_EMP
				  , CD_FILIAL
				  , CD_VD
				  , CD_IT
				  , CD_MEDICO_REC
				  , NR_RECEITA
				  , DT_RECEITA
				  , COMPRADOR_NOME
				  , COMPRADOR_DOC_NUMERO
				  , COMPRADOR_DOC_TIPO
				  , COMPRADOR_DOC_EXPEDIDOR
				  , COMPRADOR_DOC_UF
				  , PACIENTE_NOME
				  , PACIENTE_IDADE
				  , PACIENTE_TP_IDADE
				  , PACIENTE_SEXO
				  , PACIENTE_CID
				  , MEDICAMENTO_NUMERO_LOTE
				  , MEDICAMENTO_RECEITA_TIPO
				  , MEDICAMENTO_NUMERO_NOTIFICACAO
				  , MEDICAMENTO_DATA_PRESCRICAO
				  , MEDICANENTO_DATA_VENDA
				  , STS_IMPORT
				  , ORIGEM_REC FROM #RS_RET
				  
		  
/*
::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
 Marca o orçamento como já vinculado com a receita.
::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
*/			  
				  
				UPDATE CRM 
				   SET CRM.SUBSIDIO = 1
                  FROM #RS_RET RET 
					   INNER JOIN EST_ORC_GLB_MEDICO CRM ON RET.CD_EMP    = CRM.CD_EMP
													    AND RET.CD_FILIAL = CRM.CD_FILIAL
													    AND RET.CODIGO_CONTROLE_ORIGEM = CRM.NR_ORC;


PRINT 'LIMPA TABELA TEMPORARIA #RS_RET 1º INSERT ';
TRUNCATE TABLE #RS_RET;		
/*::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
  ::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::*/


			 INSERT INTO  #RS_RET(
					CD_EMP
				  , CD_FILIAL
				  , CD_VD
				  , CD_IT
				  , CD_MEDICO_REC
				  , NR_RECEITA
				  , DT_RECEITA
				  , COMPRADOR_NOME
				  , COMPRADOR_DOC_NUMERO
				  , COMPRADOR_DOC_TIPO
				  , COMPRADOR_DOC_EXPEDIDOR
				  , COMPRADOR_DOC_UF
				  , PACIENTE_NOME
				  , PACIENTE_IDADE
				  , PACIENTE_TP_IDADE
				  , PACIENTE_SEXO
				  , PACIENTE_CID
				  , MEDICAMENTO_NUMERO_LOTE
				  , MEDICAMENTO_RECEITA_TIPO
				  , MEDICAMENTO_NUMERO_NOTIFICACAO
				  , MEDICAMENTO_DATA_PRESCRICAO
				  , MEDICANENTO_DATA_VENDA
				  , STS_IMPORT
				  , ORIGEM_REC
                  , CODIGO_CONTROLE_ORIGEM)
					SELECT
						   PDV_VD_IT.CD_EMP
						 , PDV_VD_IT.CD_FILIAL
						 , PDV_VD_IT.CD_VD
						 , PDV_VD_IT.CD_IT
						 , MAX(EST_SNGPC_RECEITA.CD_CTR)
						 , MAX(RTRIM(LTRIM(EST_SNGPC_RECEITA.NR_RECEITA)))
						 , MAX(EST_SNGPC_RECEITA.DT_RECEITA)
						 , '' AS COMPRADOR_NOME
						 , '' AS COMPRADOR_DOC_NUMERO
						 , 0 AS COMPRADOR_DOC_TIPO
						 , 0 AS COMPRADOR_DOC_EXPEDIDOR
						 , '' AS COMPRADOR_DOC_UF
						 , '' AS PACIENTE_NOME
						 , 0 AS PACIENTE_IDADE
						 , 0 AS PACIENTE_TP_IDADE
						 , 0 AS PACIENTE_SEXO
						 , '' AS PACIENTE_CID
						 , '' AS MEDICAMENTO_NUMERO_LOTE
						 , 0 AS MEDICAMENTO_RECEITA_TIPO
						 , '' AS MEDICAMENTO_NUMERO_NOTIFICACAO
						 , NULL AS MEDICAMENTO_DATA_PRESCRICAO
						 , MAX(PDV_VD.DT_VD) AS MEDICANENTO_DATA_VENDA
						 , 0 AS STS_IMPORT
						 , 2 AS ORIGEM_REC
                         , PDV_VD_IT.CD_VD
					FROM
						 EST_SNGPC_RECEITA
						 INNER JOIN EST_SNGPC_SAIDA_RECEITA ON EST_SNGPC_RECEITA.CD_RECEITA = EST_SNGPC_SAIDA_RECEITA.CD_RECEITA
						 INNER JOIN PDV_VD_IT_EST_SNGPC_SAIDA ON EST_SNGPC_SAIDA_RECEITA.CD_SAI_SNGPC = PDV_VD_IT_EST_SNGPC_SAIDA.CD_SAI_SNGPC
						 INNER JOIN PDV_VD_IT ON PDV_VD_IT_EST_SNGPC_SAIDA.CD_EMP = PDV_VD_IT.CD_EMP
												 AND PDV_VD_IT_EST_SNGPC_SAIDA.CD_FILIAL = PDV_VD_IT.CD_FILIAL
												 AND PDV_VD_IT_EST_SNGPC_SAIDA.CD_VD = PDV_VD_IT.CD_VD
												 AND PDV_VD_IT_EST_SNGPC_SAIDA.CD_IT = PDV_VD_IT.CD_IT
						 INNER JOIN PDV_VD ON PDV_VD_IT.CD_VD = PDV_VD.CD_VD
											  AND PDV_VD_IT.CD_FILIAL = PDV_VD.CD_FILIAL
											  AND PDV_VD_IT.CD_EMP = PDV_VD.CD_EMP
											  AND PDV_VD_IT.DT_VD = PDV_VD.DT_VD
						 LEFT OUTER JOIN PDV_VD_IT_REC ON PDV_VD_IT.CD_EMP = PDV_VD_IT_REC.CD_EMP
														  AND PDV_VD_IT.CD_FILIAL = PDV_VD_IT_REC.CD_FILIAL
														  AND PDV_VD_IT.CD_VD = PDV_VD_IT_REC.CD_VD
														  AND PDV_VD_IT.CD_IT = PDV_VD_IT_REC.CD_IT
						 INNER JOIN GLB_MEDICOS MED ON EST_SNGPC_RECEITA.CD_EMP = MED.CD_EMP
													   AND EST_SNGPC_RECEITA.CD_CTR = MED.CD_CTR
					WHERE PDV_VD_IT.DT_VD BETWEEN @DT_INI AND @DT_FIM
						  AND PDV_VD_IT.CD_EMP = 1
						  AND PDV_VD_IT.CD_FILIAL = @CdLoja
						  AND PDV_VD_IT.ST_IT = 1
						  AND PDV_VD.ST_VD = 0
                          AND ISNULL(EST_SNGPC_RECEITA.SUBSIDIO, 0) = 0
						  AND PDV_VD_IT_REC.CD_IT IS NULL
					GROUP BY
							 PDV_VD_IT.CD_EMP
						   , PDV_VD_IT.CD_FILIAL
						   , PDV_VD_IT.CD_VD
						   , PDV_VD_IT.CD_IT;
            

				
			    PRINT 'Inserindo CRM pelo SNGPC na pdv receita - Hora : '+CONVERT(VARCHAR, GETDATE(), 108);
                INSERT INTO PDV_VD_IT_REC 
                (
					CD_EMP
				  , CD_FILIAL
				  , CD_VD
				  , CD_IT
				  , CD_MEDICO_REC
				  , NR_RECEITA
				  , DT_RECEITA
				  , COMPRADOR_NOME
				  , COMPRADOR_DOC_NUMERO
				  , COMPRADOR_DOC_TIPO
				  , COMPRADOR_DOC_EXPEDIDOR
				  , COMPRADOR_DOC_UF
				  , PACIENTE_NOME
				  , PACIENTE_IDADE
				  , PACIENTE_TP_IDADE
				  , PACIENTE_SEXO
				  , PACIENTE_CID
				  , MEDICAMENTO_NUMERO_LOTE
				  , MEDICAMENTO_RECEITA_TIPO
				  , MEDICAMENTO_NUMERO_NOTIFICACAO
				  , MEDICAMENTO_DATA_PRESCRICAO
				  , MEDICANENTO_DATA_VENDA
				  , STS_IMPORT
				  , ORIGEM_REC
				)
                SELECT CD_EMP
				  , CD_FILIAL
				  , CD_VD
				  , CD_IT
				  , CD_MEDICO_REC
				  , NR_RECEITA
				  , DT_RECEITA
				  , COMPRADOR_NOME
				  , COMPRADOR_DOC_NUMERO
				  , COMPRADOR_DOC_TIPO
				  , COMPRADOR_DOC_EXPEDIDOR
				  , COMPRADOR_DOC_UF
				  , PACIENTE_NOME
				  , PACIENTE_IDADE
				  , PACIENTE_TP_IDADE
				  , PACIENTE_SEXO
				  , PACIENTE_CID
				  , MEDICAMENTO_NUMERO_LOTE
				  , MEDICAMENTO_RECEITA_TIPO
				  , MEDICAMENTO_NUMERO_NOTIFICACAO
				  , MEDICAMENTO_DATA_PRESCRICAO
				  , MEDICANENTO_DATA_VENDA
				  , STS_IMPORT
				  , ORIGEM_REC FROM #RS_RET

/*::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
  ::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::*/				  
 			    UPDATE CRM 
				   SET CRM.SUBSIDIO = 1
                  FROM #RS_RET RET 
					   INNER JOIN PDV_VD_IT_EST_SNGPC_SAIDA ON RET.CD_EMP = PDV_VD_IT_EST_SNGPC_SAIDA.CD_EMP
														   AND RET.CD_FILIAL = PDV_VD_IT_EST_SNGPC_SAIDA.CD_FILIAL
														   AND RET.CODIGO_CONTROLE_ORIGEM = PDV_VD_IT_EST_SNGPC_SAIDA.CD_VD 
					   INNER JOIN EST_SNGPC_SAIDA_RECEITA ON PDV_VD_IT_EST_SNGPC_SAIDA.CD_SAI_SNGPC = EST_SNGPC_SAIDA_RECEITA.CD_SAI_SNGPC 
					   INNER JOIN EST_SNGPC_RECEITA CRM ON EST_SNGPC_SAIDA_RECEITA.CD_RECEITA = CRM.CD_RECEITA	  
				  

PRINT 'LIMPA TABELA TEMPORARIA #RS_RET 2º INSERT ';
TRUNCATE TABLE #RS_RET;	
/*::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
  ::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::*/	


  
			 
			 INSERT INTO #RS_RET(
					CD_EMP
				  , CD_FILIAL
				  , CD_VD
				  , CD_IT
				  , CD_MEDICO_REC
				  , NR_RECEITA
				  , DT_RECEITA
				  , COMPRADOR_NOME
				  , COMPRADOR_DOC_NUMERO
				  , COMPRADOR_DOC_TIPO
				  , COMPRADOR_DOC_EXPEDIDOR
				  , COMPRADOR_DOC_UF
				  , PACIENTE_NOME
				  , PACIENTE_IDADE
				  , PACIENTE_TP_IDADE
				  , PACIENTE_SEXO
				  , PACIENTE_CID
				  , MEDICAMENTO_NUMERO_LOTE
				  , MEDICAMENTO_RECEITA_TIPO
				  , MEDICAMENTO_NUMERO_NOTIFICACAO
				  , MEDICAMENTO_DATA_PRESCRICAO
				  , MEDICANENTO_DATA_VENDA
				  , STS_IMPORT
				  , ORIGEM_REC
                  , CODIGO_CONTROLE_ORIGEM )
					SELECT
						   PDV_VD_IT.CD_EMP
						 , PDV_VD_IT.CD_FILIAL
						 , PDV_VD_IT.CD_VD
						 , PDV_VD_IT.CD_IT
						 , MAX(TELE_ORC_ITEM_RECEITA.CD_MED)
						 , MAX(RTRIM(LTRIM(TELE_ORC_ITEM_RECEITA.NR_RECEITA)))
						 , MAX(TELE_ORC_ITEM_RECEITA.DT_RECEITA)
						 , '' AS COMPRADOR_NOME
						 , '' AS COMPRADOR_DOC_NUMERO
						 , 0 AS COMPRADOR_DOC_TIPO
						 , '' AS COMPRADOR_DOC_EXPEDIDOR
						 , '' AS COMPRADOR_DOC_UF
						 , '' AS PACIENTE_NOME
						 , 0 AS PACIENTE_IDADE
						 , 0 AS PACIENTE_TP_IDADE
						 , 0 AS PACIENTE_SEXO
						 , '' AS PACIENTE_CID
						 , '' AS MEDICAMENTO_NUMERO_LOTE
						 , 0 AS MEDICAMENTO_RECEITA_TIPO
						 , '' AS MEDICAMENTO_NUMERO_NOTIFICACAO
						 , NULL AS MEDICAMENTO_DATA_PRESCRICAO
						 , MAX(PDV_VD.DT_VD) AS MEDICANENTO_DATA_VENDA
						 , 0 AS STS_IMPORT
						 , 1 AS ORIGEM_REC
                         , MAX(TELE_ORC_ITEM_RECEITA.CD_ORC_ITEM)
					FROM
						 TELE_ORC
						 INNER JOIN PDV_VD ON TELE_ORC.CD_EMP = PDV_VD.CD_EMP
											  AND TELE_ORC.CD_FILIAL = PDV_VD.CD_FILIAL
											  AND TELE_ORC.CD_ORC = PDV_VD.NR_PED_TELEVD
						 INNER JOIN PDV_VD_IT ON PDV_VD_IT.CD_VD = PDV_VD.CD_VD
												 AND PDV_VD_IT.CD_FILIAL = PDV_VD.CD_FILIAL
												 AND PDV_VD_IT.CD_EMP = PDV_VD.CD_EMP
												 AND PDV_VD_IT.DT_VD = PDV_VD.DT_VD
						 INNER JOIN TELE_ORC_ITEM ON TELE_ORC.CD_ORC = TELE_ORC_ITEM.CD_ORC
						 INNER JOIN TELE_ORC_ITEM_RECEITA ON TELE_ORC_ITEM.CD_ORC_ITEM = TELE_ORC_ITEM_RECEITA.CD_ORC_ITEM
						 LEFT OUTER JOIN PDV_VD_IT_REC ON PDV_VD_IT.CD_EMP = PDV_VD_IT_REC.CD_EMP
														  AND PDV_VD_IT.CD_FILIAL = PDV_VD_IT_REC.CD_FILIAL
														  AND PDV_VD_IT.CD_VD = PDV_VD_IT_REC.CD_VD
														  AND PDV_VD_IT.CD_IT = PDV_VD_IT_REC.CD_IT
						 INNER JOIN GLB_MEDICOS ON GLB_MEDICOS.CD_EMP = TELE_ORC.CD_EMP
												   AND GLB_MEDICOS.CD_CTR = TELE_ORC_ITEM_RECEITA.CD_MED
					WHERE PDV_VD_IT.DT_VD BETWEEN @DT_INI AND @DT_FIM
						  AND PDV_VD_IT.CD_EMP = 1
						  AND PDV_VD_IT.ST_IT = 1
						  AND PDV_VD.ST_VD = 0
                          AND ISNULL(TELE_ORC_ITEM_RECEITA.SUBSIDIO, 0) = 0
						  AND PDV_VD_IT_REC.CD_IT IS NULL
						  AND PDV_VD_IT.CD_FILIAL = @CdLoja
					GROUP BY
							 PDV_VD_IT.CD_EMP
						   , PDV_VD_IT.CD_FILIAL
						   , PDV_VD_IT.CD_VD
						   , PDV_VD_IT.CD_IT;


				PRINT 'Inserindo CRM pelo TELEVENDAS no cupom fiscal receita- Hora : '+CONVERT(VARCHAR, GETDATE(), 108);
                INSERT INTO PDV_VD_IT_REC 
                (
					CD_EMP
				  , CD_FILIAL
				  , CD_VD
				  , CD_IT
				  , CD_MEDICO_REC
				  , NR_RECEITA
				  , DT_RECEITA
				  , COMPRADOR_NOME
				  , COMPRADOR_DOC_NUMERO
				  , COMPRADOR_DOC_TIPO
				  , COMPRADOR_DOC_EXPEDIDOR
				  , COMPRADOR_DOC_UF
				  , PACIENTE_NOME
				  , PACIENTE_IDADE
				  , PACIENTE_TP_IDADE
				  , PACIENTE_SEXO
				  , PACIENTE_CID
				  , MEDICAMENTO_NUMERO_LOTE
				  , MEDICAMENTO_RECEITA_TIPO
				  , MEDICAMENTO_NUMERO_NOTIFICACAO
				  , MEDICAMENTO_DATA_PRESCRICAO
				  , MEDICANENTO_DATA_VENDA
				  , STS_IMPORT
				  , ORIGEM_REC
				)
                SELECT CD_EMP
				  , CD_FILIAL
				  , CD_VD
				  , CD_IT
				  , CD_MEDICO_REC
				  , NR_RECEITA
				  , DT_RECEITA
				  , COMPRADOR_NOME
				  , COMPRADOR_DOC_NUMERO
				  , COMPRADOR_DOC_TIPO
				  , COMPRADOR_DOC_EXPEDIDOR
				  , COMPRADOR_DOC_UF
				  , PACIENTE_NOME
				  , PACIENTE_IDADE
				  , PACIENTE_TP_IDADE
				  , PACIENTE_SEXO
				  , PACIENTE_CID
				  , MEDICAMENTO_NUMERO_LOTE
				  , MEDICAMENTO_RECEITA_TIPO
				  , MEDICAMENTO_NUMERO_NOTIFICACAO
				  , MEDICAMENTO_DATA_PRESCRICAO
				  , MEDICANENTO_DATA_VENDA
				  , STS_IMPORT
				  , ORIGEM_REC FROM #RS_RET
				  
				  
/*::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
  ::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::*/				  

                UPDATE CRM SET CRM.SUBSIDIO = 1
                    FROM #RS_RET RET INNER JOIN 
                         TELE_ORC_ITEM_RECEITA CRM ON 
                            RET.CODIGO_CONTROLE_ORIGEM = CRM.CD_ORC_ITEM
							

PRINT 'LIMPA TABELA TEMPORARIA #RS_RET 3º INSERT ';
TRUNCATE TABLE #RS_RET;								
/*
::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::				  
*/
			
			 PRINT 'Inserindo CRM pelo SNGPC na nota fiscal receita- Hora : '+CONVERT(VARCHAR, GETDATE(), 108);
			 INSERT INTO EST_NF_SAI_IT_RECEITA
				( CD_EMP
				  , CD_FILIAL
				  , CD_NF
				  , CD_PROD
				  , CD_IT
				  , CD_MEDICO_REC
				  , NR_RECEITA
				  , DT_RECEITA
				  , COMPRADOR_NOME
				  , COMPRADOR_DOC_NUMERO
				  , COMPRADOR_DOC_TIPO
				  , COMPRADOR_DOC_EXPEDIDOR
				  , COMPRADOR_DOC_UF
				  , PACIENTE_NOME
				  , PACIENTE_IDADE
				  , PACIENTE_TP_IDADE
				  , PACIENTE_SEXO
				  , PACIENTE_CID
				  , MEDICAMENTO_NUMERO_LOTE
				  , MEDICAMENTO_RECEITA_TIPO
				  , MEDICAMENTO_NUMERO_NOTIFICACAO
				  , MEDICAMENTO_DATA_PRESCRICAO
				  , MEDICANENTO_DATA_VENDA
				  , STS_IMPORT
				  , ORIGEM_REC )
					SELECT DISTINCT
						   EST_NF_SAI_IT_EST_SNGPC_SAIDA.CD_EMP
						 , EST_NF_SAI_IT_EST_SNGPC_SAIDA.CD_FILIAL
						 , EST_NF_SAI_IT_EST_SNGPC_SAIDA.CD_NF
						 , EST_NF_SAI_IT_EST_SNGPC_SAIDA.CD_PROD
						 , EST_NF_SAI_IT_EST_SNGPC_SAIDA.CD_IT
						 , MAX(EST_SNGPC_RECEITA.CD_CTR) AS CD_CRM
						 , MAX(RTRIM(LTRIM(EST_SNGPC_RECEITA.NR_RECEITA))) AS NR_RECEITA
						 , MAX(EST_SNGPC_RECEITA.DT_RECEITA) AS DT_RECEITA
						 , '' AS COMPRADOR_NOME
						 , '' AS COMPRADOR_DOC_NUMERO
						 , 0 AS COMPRADOR_DOC_TIPO
						 , '' AS COMPRADOR_DOC_EXPEDIDOR
						 , '' AS COMPRADOR_DOC_UF
						 , '' AS PACIENTE_NOME
						 , 0 AS PACIENTE_IDADE
						 , 0 AS PACIENTE_TP_IDADE
						 , 0 AS PACIENTE_SEXO
						 , '' AS PACIENTE_CID
						 , '' AS MEDICAMENTO_NUMERO_LOTE
						 , 0 AS MEDICAMENTO_RECEITA_TIPO
						 , '' AS MEDICAMENTO_NUMERO_NOTIFICACAO
						 , NULL AS MEDICAMENTO_DATA_PRESCRICAO
						 , MAX(EST_NF_SAI.DT_EMI_NF) AS MEDICANENTO_DATA_VENDA
						 , 0 AS STS_IMPORT
						 , 2
					FROM
						 EST_NF_SAI_IT_EST_SNGPC_SAIDA
						 INNER JOIN EST_SNGPC_SAIDA_RECEITA ON EST_NF_SAI_IT_EST_SNGPC_SAIDA.CD_SAI_SNGPC = EST_SNGPC_SAIDA_RECEITA.CD_SAI_SNGPC
						 INNER JOIN EST_SNGPC_RECEITA ON EST_SNGPC_SAIDA_RECEITA.CD_RECEITA = EST_SNGPC_RECEITA.CD_RECEITA
						 INNER JOIN EST_NF_SAI ON EST_NF_SAI_IT_EST_SNGPC_SAIDA.CD_EMP = EST_NF_SAI.CD_EMP
												  AND EST_NF_SAI_IT_EST_SNGPC_SAIDA.CD_FILIAL = EST_NF_SAI.CD_FILIAL
												  AND EST_NF_SAI_IT_EST_SNGPC_SAIDA.CD_NF = EST_NF_SAI.CD_NF
						 INNER JOIN GLB_MOV_OP ON EST_NF_SAI.CD_NT_MOV = GLB_MOV_OP.CD_MOV_OP
						 LEFT OUTER JOIN EST_NF_SAI_IT_RECEITA ON EST_NF_SAI_IT_EST_SNGPC_SAIDA.CD_EMP = EST_NF_SAI_IT_RECEITA.CD_EMP
																  AND EST_NF_SAI_IT_EST_SNGPC_SAIDA.CD_FILIAL = EST_NF_SAI_IT_RECEITA.CD_FILIAL
																  AND EST_NF_SAI_IT_EST_SNGPC_SAIDA.CD_NF = EST_NF_SAI_IT_RECEITA.CD_NF
																  AND EST_NF_SAI_IT_EST_SNGPC_SAIDA.CD_PROD = EST_NF_SAI_IT_RECEITA.CD_PROD
																  AND EST_NF_SAI_IT_EST_SNGPC_SAIDA.CD_IT = EST_NF_SAI_IT_RECEITA.CD_IT
						--ADICIONADO PARA EVITAR RECEITAS COM CRM ZERADO
						INNER JOIN GLB_MEDICOS MED ON MED.CD_EMP = EST_SNGPC_RECEITA.CD_EMP AND MED.CD_CTR = EST_SNGPC_RECEITA.CD_CTR 
					WHERE EST_NF_SAI_IT_RECEITA.CD_NF IS NULL
						  AND EST_NF_SAI.CD_EMP = 1
						    AND EST_NF_SAI.CD_FILIAL = @CdLoja
					GROUP BY
							 EST_NF_SAI_IT_EST_SNGPC_SAIDA.CD_EMP
						   , EST_NF_SAI_IT_EST_SNGPC_SAIDA.CD_FILIAL
						   , EST_NF_SAI_IT_EST_SNGPC_SAIDA.CD_NF
						   , EST_NF_SAI_IT_EST_SNGPC_SAIDA.CD_PROD
						   , EST_NF_SAI_IT_EST_SNGPC_SAIDA.CD_IT;
						   
 			 
						FETCH NEXT FROM cFiliais INTO @CdLoja;
             END;    
         CLOSE cFiliais;    
         DEALLOCATE cFiliais;

     END;

/*
-- :::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
-- Tag #A001

 	PRINT 'EXEC P_SNGPC_SAIDA_AUTOMATICA ' + CONVERT(VARCHAR, GETDATE(), 108);
 	EXEC P_SNGPC_SAIDA_AUTOMATICA; 
	
-- ::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::	
*/	

	
	
	
	
	
	
